/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.network;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.network.Networking;
import dev.toma.configuration.network.api.IClientPacket;
import dev.toma.configuration.network.api.IPacketDecoder;
import dev.toma.configuration.network.api.IPacketEncoder;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class S2C_SendConfigData
implements IClientPacket<ConfigData> {
    public static final class_2960 IDENTIFIER = new class_2960("configuration", "s2c_send_config_data");
    private final ConfigData config;

    S2C_SendConfigData() {
        this.config = null;
    }

    public S2C_SendConfigData(String config) {
        this.config = new ConfigData(config);
    }

    @Override
    public class_2960 getPacketId() {
        return IDENTIFIER;
    }

    @Override
    public ConfigData getPacketData() {
        return this.config;
    }

    @Override
    public IPacketEncoder<ConfigData> getEncoder() {
        return (configData, buffer) -> {
            buffer.method_10814(configData.configId);
            ConfigHolder.getConfig(configData.configId).ifPresent(data -> {
                Map<String, ConfigValue<?>> serialized = data.getNetworkSerializedFields();
                buffer.writeInt(serialized.size());
                for (Map.Entry<String, ConfigValue<?>> entry : serialized.entrySet()) {
                    String id = entry.getKey();
                    ConfigValue<?> value = entry.getValue();
                    TypeAdapter adapter = value.getAdapter();
                    buffer.method_10814(id);
                    adapter.encodeToBuffer(value, buffer);
                }
            });
        };
    }

    @Override
    public IPacketDecoder<ConfigData> getDecoder() {
        return buffer -> {
            String config = buffer.method_19772();
            int i = buffer.readInt();
            ConfigHolder.getConfig(config).ifPresent(data -> {
                Map<String, ConfigValue<?>> serialized = data.getNetworkSerializedFields();
                for (int j = 0; j < i; ++j) {
                    String fieldId = buffer.method_19772();
                    ConfigValue<?> value = serialized.get(fieldId);
                    if (value == null) {
                        Configuration.LOGGER.fatal(Networking.MARKER, "Received unknown config value " + fieldId);
                        throw new RuntimeException("Unknown config field: " + fieldId);
                    }
                    this.setValue(value, buffer);
                }
            });
            return new ConfigData(config);
        };
    }

    @Override
    public void handleClientsidePacket(class_310 client, class_634 listener, ConfigData packetData, PacketSender dispatcher) {
    }

    private <V> void setValue(ConfigValue<V> value, class_2540 buffer) {
        TypeAdapter adapter = value.getAdapter();
        Object v = adapter.decodeFromBuffer(value, buffer);
        value.set(v);
    }

    static final class ConfigData {
        private final String configId;

        public ConfigData(String configId) {
            this.configId = configId;
        }
    }
}

